//
//  NSImage+CRKit.h
//  CRKit
//
//  Created by Yaroslav Glushchenko on 6/16/09.
//  Copyright 2009 Corner-A. All rights reserved.
//


//////////////////////////////////////////////////////////////////////
// NSImage category for convert to CIImage
//////////////////////////////////////////////////////////////////////
@interface NSImage (CRKit)

- (id)initWithDataRespectingSize:(NSData *)data;
- (id)initWithContentsOfFileRespectingSize:(NSString *)fileName;

+ (NSString *)smartPath:(NSString *)path inBundle:(NSBundle *)bundle mapping:(NSDictionary *)mapping;
+ (NSImage *)imageForSmartPath:(NSString *)path;
+ (NSImage *)imageForSmartPath:(NSString *)path inBundle:(NSBundle *)bundle;
+ (NSImage *)imageForSmartPath:(NSString *)path inBundle:(NSBundle *)bundle mapping:(NSDictionary *)mapping;

+ (NSImage *)image:(NSString *)imageName inBundle:(NSBundle *)bundle;
+ (NSImage *)imageNamed:(NSString *)imageName inBundleDirectory:(NSString *)directory;
+ (NSImage *)loadThumbnailFromFile:(NSString *)fullPath ofSize:(NSUInteger)maxSize;

- (NSImage *)thumbnailOfSize:(NSSize)size;
- (NSImage *)imageOfSize:(NSSize)size;
- (NSImage *)copyWithAlpha:(float)alpha;
- (NSImage *)tintedWithColor:(NSColor *)tint;
- (NSBitmapImageRep *)bitmap:(BOOL)keepPixelSize;
- (NSBitmapImageRep *)bitmap;

- (void)lockFocusFlippedOSIndependent;
- (void)unlockFocusOSIndependent;

@end